/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package sdk;

import com.sun.jna.Callback;
//import com.sun.jna.Library;
import com.sun.jna.Library;
import com.sun.jna.Structure;
/**
 *
 * @author Administrator
 */
public class READERDLLAPI {

    // 1.实现VHLib.dll 文件接口    
    public interface READERDLL extends Library {   
 
        public short _OK   =   0;
        
        public static class BYTEA extends Structure
	{
            public byte[] Data = new byte[256];
            //public byte[255] data;
            
	}   
        
        public static class ReaderDate extends Structure
	{
            public byte Year;
            public byte Month;
            public byte Day;       
            public byte Hour;      
            public byte Minute;      
            public byte Second;       
		 
	}   
        
        
        public static class HandsetParam extends Structure
        {
            public byte	TagType;		//标签种类：01H－ISO18000-6B，02H－EPCC1，04H－EPCC1G2，08H－EM4442。	(0)
            public byte	Alarm;			//bit0-bit7 bit0:0-不报警，1-报警 bit1 0-不使用白名单 1-使用白名单。	(1)
            public byte	OutputMode;	    //数据输出模式：0-保存并直接输出,1-保存但不直接输出,2-不保存但直接输出  (2)
            public byte	USBBaudRate;	//USB接口波特率 04-9600 05-19200  06-38400  07-57600 08-115200			(3)
            public byte	BtBaudRate;		//蓝牙串口通讯波特率													(4)
            public byte	Min_Frequence;	//发射微波信号频率的起始点，取值： 1~63。								(5)
            public byte	Max_Frequence;	//发射微波信号频率的起始点，取值： 1~63。								(6)
            public byte	Power;			//发射功率值，取值：0~160。												(7)
            public byte	RFhrdVer1;		//RF模块硬件主版本														(8)
            public byte	RFhrdVer2;		//RF模块硬件次版本														(9)
            public byte	RFSoftVer1;		//RF模块软件主版本														(10)
            public byte	RFSoftVer2;		//RF模块软件次版本														(11)
            public byte	ISTID;		    //是否读TID区															(12)
            public byte	TIDAddr;		//TID读取起始位置														(13)
            public byte	TIDLen;		    //TID读取长度															(14)
            public byte	ISUSER;		    //是否读USER															(15)
            public byte	USERAddr;		//USER读取起始位置														(16)
            public byte	USERLen;		//USER读取长度															(17)
            public byte	ISVibrate;		//电机振动,0-不，1-振动													(18)
            public byte	Modutype;		//模块类型,0---R2000, 1---VM5E											(19)
            public byte	Reserve21;		//保留																	(20)
            public byte	Reserve22;		//保留																	(21)
            public byte	Reserve23;		//保留																	(22)
            public byte	Reserve24;		//保留																	(23)
            public byte	Reserve25;		//保留																	(24)
            public byte	Reserve26;		//保留																	(25)
            public byte	Reserve27;		//保留																	(26)
            public byte	Reserve28;		//保留																	(27)
            public byte	Reserve29;		//保留																	(28)
            public byte	Reserve30;		//保留																	(29)
            public byte	Reserve31;		//保留																	(30)
            public byte	Reserve32;		//保留																	(31)
        }
        
        
        
        
        
        //连接读写器
        //apiReturn _stdcall ConnectScanner(HANDLE *hScanner, char *szPort, int *nBaudRate);
        public short ConnectScanner(int hScanner[], String szPort, int nBaudRate);
        
        
        //断开连接
        //apiReturn _stdcall DisconnectScanner(HANDLE hScanner);
        public short DisconnectScanner(int hScanner);
        
        
        //通过USB连接读写器
        //apiReturn _stdcall VH_ConnectScannerUsb(HANDLE *hScanner);
        public short VH_ConnectScannerUsb(int hScanner[]);
        

        //断开连接
        //apiReturn _stdcall VH_DisconnectScannerUsb(HANDLE hScanner);
        public short VH_DisconnectScannerUsb(int hScanner);

        
        //读取版本号
        //apiReturn _stdcall VH_GetVersion(HANDLE hScanner, WORD *wHardVer, WORD  *wSoftVer);
        //读取版本号
        public short VH_GetVersion(int hScanner, short wHardVer[], short  wSoftVer[]);
        
        
        //////////////////////////////////////////////////////////////////////////
        //用途:		设置输出日志文件
        //函数名:	VH_SetLogFile
        //功能:		将日志功能写入到指定文件中
        //输入参数:	FileName 指全路径名
        //输出参数:	无
        //返回值:	返回0为成功，否则-1为失败
        //备注:
        //////////////////////////////////////////////////////////////////////////
        public short VH_SetLogFile(String FileName);


        //////////////////////////////////////////////////////////////////////////
        //用途:		设置通信方式
        //函数名:	Mux_SetCommunicationOpt
        //功能:		对手持机的通信模式进行设置
        //输入参数:	lOpt 为何种方式通信(0--TCP/IP, 1--RS232,2--RS485, 3--USB)
        //			lpRHand 为读写器的句柄
        //输出参数:	
        //返回值:	返回 0 为成功，其它失败
        //备注:		外部接口
        //////////////////////////////////////////////////////////////////////////
        //apiReturn _stdcall VH_SetCommunicationOpt(long lOpt, void *lpRWHand)
        public short VH_SetCommunicationOpt(long lOpt, char lpRWHand[]);
        

        //获取读写器基本工作参数
        //apiReturn _stdcall ReadHanderParam(HANDLE hScanner, HandsetParam * pParam);
        public short ReadHanderParam(int hScanner, HandsetParam pParam[]);


        //设置读写器基本工作参数
        public short WriteHanderParam(int hScanner, HandsetParam pParam[]);


        //读取EPC1G2标签ID号
        //apiReturn _stdcall EPC1G2_ReadLabelID(HANDLE hScanner, BYTE mem, int ptr, BYTE len, BYTE *mask, BYTE *IDBuffer, int *nCounter,int Address);
        public short EPC1G2_ReadLabelID(int hScanner, int mem, int ptr, int len, byte[] mask, byte[] IDBuffer, int []nCounter, int Address);


        //设置手机进入读写器模式，即模块电源打开，1--打开，0--关闭
        //apiReturn _stdcall SetReaderMode(HANDLE hScanner, BYTE nMode);
        public short SetReaderMode(int hScanner, byte nMode);
        
        
        //永久休眠标签
        //apiReturn _stdcall EPC1G2_KillTag(HANDLE hScanner, BYTE EPC_WORD, BYTE *IDBuffer, BYTE *KillPassword,int Address);
        public short EPC1G2_KillTag(int hScanner, int EPC_WORD, byte[] IDBuffer, byte[] KillPassword, int Address);
        
        
        //读一块数据
        //apiReturn _stdcall EPC1G2_ReadWordBlock(HANDLE hScanner, BYTE EPC_WORD, BYTE *IDBuffer, BYTE mem, BYTE ptr, BYTE len, BYTE *Data, BYTE *AccessPassword,int Address);
        public short EPC1G2_ReadWordBlock(int hScanner, int EPC_WORD, byte[] IDBuffer, int mem, int ptr, int len, byte[] Data, byte[] AccessPassword, int Address);
        
        
        //写一块数据
        //apiReturn _stdcall EPC1G2_WriteWordBlock(HANDLE hScanner, BYTE EPC_WORD, BYTE *IDBuffer, BYTE mem, BYTE ptr, BYTE len, BYTE *Data, BYTE *AccessPassword,int Address);
        public short EPC1G2_WriteWordBlock(int hScanner, int EPC_WORD, byte[] IDBuffer, int mem, int ptr, int len, byte[] Data, byte[] AccessPassword, int Address);
            
            
        //设置读写保护状态
        //apiReturn _stdcall EPC1G2_SetLock(HANDLE hScanner, BYTE EPC_WORD, BYTE *IDBuffer, BYTE mem, BYTE Lock, BYTE *AccessPassword,int Address);
        public short EPC1G2_SetLock(int hScanner, int EPC_WORD, byte[] IDBuffer, int mem, int Lock, byte[] AccessPassword, int Address);
        
        
        //块锁命令
        //apiReturn _stdcall EPC1G2_BlockLock(HANDLE hScanner, BYTE EPC_WORD, BYTE *IDBuffer, BYTE ptr, BYTE *AccessPassword,int Address);
        public short EPC1G2_BlockLock(int hScanner, int EPC_WORD, byte[] IDBuffer, int ptr, byte[] AccessPassword, int Address);
            
        
        //EAS状态操作命令
        //apiReturn _stdcall EPC1G2_ChangeEas(HANDLE hScanner, BYTE EPC_WORD, BYTE *IDBuffer, BYTE State, BYTE *AccessPassword,int Address);
        public short EPC1G2_ChangeEas(int hScanner, int EPC_WORD, byte[] IDBuffer, int State, byte[] AccessPassword, int Address);
        
        
        //EAS报警命令
        //apiReturn _stdcall EPC1G2_EasAlarm(HANDLE hScanner,int Address);
        public short EPC1G2_EasAlarm(int hScanner, int Address);
        
        
        //读保护设置
        //apiReturn _stdcall EPC1G2_ReadProtect(HANDLE hScanner,BYTE *AccessPassword, BYTE EPC_WORD, BYTE *IDBuffer,int Address);
        public short EPC1G2_ReadProtect(int hScanner,byte[] AccessPassword, int EPC_WORD, byte[] IDBuffer, int Address);
        
        
        //复位读保护设置
        //apiReturn _stdcall EPC1G2_RStreadProtect(HANDLE hScanner, BYTE *AccessPassword,int Address);
        public short EPC1G2_RStreadProtect(int hScanner, byte[] AccessPassword, int Address);
            
        
        //设置读写器ID
        public short SetHandsetID(int hScanner, byte[] HandsetID);
        

        //获得读写器ID
        public short GetHandsetID(int hScanner, byte[] HandsetID);


        public short SetReaderTime(int hScanner, ReaderDate time);


        //获得时间
        public short GetReaderTime(int hScanner, byte[] time);


        //设置标签过滤器
        public short SetReportFilter(int hScanner, int ptr, int len, byte[] mask);


        //获得标签过滤器
        public short GetReportFilter(int hScanner, int[] ptr, int[] len, byte[] mask);


        //设置蓝牙波特率
        public short SetBtBaudRate(int hScanner, int nBaudRate);
        

        //获取蓝牙波特率
        public short GetBtBaudRate(int hScanner, int nBaudRate[]);
        

        //获得蓝牙名称
        public short SetBluetoothName(int hScanner,int nLen, byte BluetoothName[]);
        

        //设置蓝牙名称
        public short GetBluetoothName(int hScanner, byte BluetoothName[]);
        

        //////////////////////////////////////////////////////////////////////////
        //用途:		获取时间段的记录总数
        //函数名:	VH_GetRecordNum
        //功能:		取记录总数
        //输入参数:	hScanner 通信句柄
        //			stime 为起始时间，etime 为结束时间
        //输出参数:	nTotal 为记录总数
        //返回值:	0--成功，其它失败
        //备注:		注意：如果起始时间和结束时间都为0,则取机器中全部记录。
        //////////////////////////////////////////////////////////////////////////
        //apiReturn _stdcall VH_GetRecordNum(HANDLE hScanner, ReaderDate *stime, ReaderDate *etime, int *nTotal);
        public short VH_GetRecordNum(int hScanner, ReaderDate stime, ReaderDate etime, int nTotal[]);

        
        //////////////////////////////////////////////////////////////////////////
        //用途:		获取时间段的记录
        //函数名:	VH_GetRecord
        //功能:		取记录
        //输入参数:	hScanner 通信句柄
        //			stime 为起始时间，etime 为结束时间
        //输出参数:	nTotal 为记录总数, nDiNum 为第几条，从0开始算, data 指记录指针
        //返回值:	0--成功，其它失败
        //备注:		注意：如果起始时间和结束时间都为0,则取机器中全部记录。
        //////////////////////////////////////////////////////////////////////////
        //apiReturn _stdcall VH_GetRecord(HANDLE hScanner, ReaderDate *stime, ReaderDate *etime, int *nTotal, int *nDiNum, BYTE * data);        
        public short VH_GetRecord(int hScanner, ReaderDate  stime, ReaderDate  etime, int nTotal[], int nDiNum[], byte data[]);


        //删除全部记录
        //apiReturn _stdcall DeleteAllRecord(HANDLE hScanner);
        public short DeleteAllRecord(int hScanner);        

        
        
        public interface MyCallInterface extends Callback
        {
            short invoke(byte data[]);
        }
        
        //高速获得记录
        //apiReturn _stdcall VH_GetRecordHigh(HANDLE hScanner, VH_fGetRecordData fFunc);
        public short VH_GetRecordHigh(int hScanner, MyCallInterface fFunc);
        
        
        public interface MyCallInterfaceTest extends Callback
        {
            short invoke();
        }
        
        //高速获得记录
        //apiReturn _stdcall VH_GetRecordHigh(HANDLE hScanner, VH_fGetRecordData fFunc);
        public short VH_GetRecordHighTest(int hScanner, MyCallInterfaceTest fFunc);
        

        public interface MyCallInterfaceTestS extends Callback
        {
            short invoke(String Data);
        }
        
        //高速获得记录
        //apiReturn _stdcall VH_GetRecordHigh(HANDLE hScanner, VH_fGetRecordData fFunc);
        public short VH_GetRecordHighTestS(int hScanner, MyCallInterfaceTestS fFunc);
        
        
        //增加名单
        //apiReturn _stdcall AddLableID(HANDLE hScanner, int Count, int Len, BYTE * data);
        public short AddLableID(int hScanner, int Count, int Len, byte data[]);

        
        //删除名单
        //apiReturn _stdcall DelLableID(HANDLE hScanner);
        public short DelLableID(int hScanner);

        
        //增加单个或多个名单
        //apiReturn _stdcall DelSingleLableID(HANDLE hScanner, int Count, int Len, BYTE * data);
        public short DelSingleLableID(int hScanner, int Count, int Len, byte data[]);

        
        //获得名单
        //apiReturn _stdcall GetLableID(HANDLE hScanner, int startaddr, int listlen, int *nTotal, int *DataLen, BYTE * data);
        public short GetLableID(int hScanner, int startaddr, int listlen, int nTotal[], int DataLen[], byte data[]);

        
        //提交名单
        //apiReturn _stdcall SaveLableID(HANDLE hScanner);
        public short SaveLableID(int hScanner);
        
        
        
    }       
}
